import request from "@/utils/request";

/**
 * 保存用户银行卡信息 bankInfo
 * @param {*} params bankName string
 * @param {*}
 * @returns
 */
export function addUserBankInfo(params) {
  return request({
    url: "/bank/add",
    method: "post",
    data: params
  });
}

/**
 * 编辑银行卡信息
 * @param {*} params
 * @returns
 */
export function editUserBankInfo(params) {
  return request({
    url: "/bank/edit",
    method: "post",
    data: params
  });
}
/**
 * 提现发送验证码
 * @param {*} params userId
 * @returns
 */
export function sendSms(params) {
  return request({
    url: "/bank/sendSmsCode",
    method: "get",
    params
  });
}

/**
 * 提现
 * @param {*} params code 验证码
 * @param {*} params money 提现金额
 * @returns
 */
export function cashOut(params) {
  return request({
    url: "/bank/userWithdrawBank",
    methods: "post",
    data: params
  });
}

/**
 * 获取用户银行卡信息
 * @param {*} params
 * @returns
 */
export function getUserBankInfo(params) {
  return request({
    url: "/bank/getByUserId",
    method: "get",
    params
  });
}
