import request from "@/utils/request";

/**
 *  获取用户钱包
 * @param {*} params userId
 */
export function getMoneyPackage(params) {
  return request({
    url: "/wallet/getMoneyPackage",
    method: "get",
    params
  });
}

/**
 * 获取用户钱包-可提现
 * @param {*} params userId
 */
export function getWithdrawalAmount(params) {
  return request({
    url: "/wallet/getWithdrawalAmount",
    method: "get",
    params
  });
}

/**
 * 提现记录
 * @param {*} params userId
 * @param {*}yearMonth yyyy-MM-dd
 */
export function getWithdrawalRecord(params) {
  return request({
    url: "/wallet/getWithdrawalRecord",
    method: "get",
    params
  });
}

/**
 * 获取用户钱包-累计收益明细
 * @param {*} params userId
 */
export function queryIncomeDetail(params) {
  return request({
    url: "/wallet/queryIncomeDetail",
    method: "get",
    params
  });
}

/**
 * 获取用户钱包-累计收益记录
 * @param {*} params userId
 */

export function showIncomeRecord(params) {
  return request({
    url: "/wallet/showIncomeRecord",
    method: "get",
    params
  });
}
