const levels = {
  0: "普通用户",
  1: "幼苗",
  2: "青铜树",
  3: "白银树",
  4: "黄金树",
  5: "农场主",
  6: "森林之星",
  7: "西田森合伙人"
};
const getDesOfield = {
  differenceAmount: "差额",
  recommendDifferenceSeedling: "幼苗",
  recommendDifferenceSilver: "白银",
  recommendDifferenceGold: "黄金",
  teamDifferenceBronze: "青铜",
  teamDifferenceSilver: "白银",
  teamDifferenceGold: "黄金",
  recommendDifferenceFarmer: "农场主",
  recommendDifferenceForestStart: "森林之星"
};
export let diffrentOflevel = {
  0: [
    {
      label: getDesOfield["differenceAmount"],
      field: "differenceAmount",
      type: "amount",
      index: 1
    }
  ],
  1: [
    {
      label: getDesOfield["differenceAmount"],
      field: "differenceAmount",
      type: "amount",
      index: 1
    }
  ],
  2: [
    {
      label: getDesOfield["recommendDifferenceSeedling"],
      field: "recommendDifferenceSeedling",
      type: "recommend",
      index: 1
    }
  ],
  3: [
    {
      label: getDesOfield["recommendDifferenceSeedling"],
      field: "recommendDifferenceSeedling",
      type: "recommend",
      index: 1
    },
    {
      label: getDesOfield["recommendDifferenceSilver"],
      field: "recommendDifferenceSilver",
      type: "recommend",
      index: 2
    },
    {
      label: getDesOfield["teamDifferenceBronze"],
      field: "teamDifferenceBronze",
      type: "team",
      index: 1
    }
  ],
  4: [
    {
      label: getDesOfield["recommendDifferenceSeedling"],
      field: "recommendDifferenceSeedling",
      type: "recommend",
      index: 1
    },
    {
      label: getDesOfield["recommendDifferenceGold"],
      field: "recommendDifferenceGold",
      type: "recommend",
      index: 2
    },
    {
      label: getDesOfield["teamDifferenceSilver"],
      field: "teamDifferenceSilver",
      type: "team",
      index: 1
    }
  ],
  5: [
    {
      label: getDesOfield["recommendDifferenceSeedling"],
      field: "recommendDifferenceSeedling",
      type: "recommend",
      index: 1
    },
    {
      label: getDesOfield["recommendDifferenceFarmer"],
      field: "recommendDifferenceFarmer",
      type: "recommend",
      index: 2
    },
    {
      label: getDesOfield["teamDifferenceSilver"],
      field: "teamDifferenceSilver",
      type: "team",
      index: 1
    },
    {
      label: getDesOfield["teamDifferenceGold"],
      field: "teamDifferenceGold",
      type: "team",
      index: 2
    }
  ],
  6: [
    {
      label: getDesOfield["recommendDifferenceSeedling"],
      field: "recommendDifferenceSeedling",
      type: "recommend",
      index: 1
    },
    {
      label: getDesOfield["recommendDifferenceFarmer"],
      field: "recommendDifferenceFarmer",
      type: "recommend",
      index: 2
    },
    {
      label: getDesOfield["recommendDifferenceForestStart"],
      field: "recommendDifferenceForestStart",
      type: "recommend",
      index: 3
    },
    {
      label: getDesOfield["teamDifferenceSilver"],
      field: "teamDifferenceSilver",
      type: "team",
      index: 1
    },
    {
      label: getDesOfield["teamDifferenceGold"],
      field: "teamDifferenceGold",
      type: "team",
      index: 2
    }
  ]
};
export function getLevelDes(level) {
  const label = levels[level];
  if (label) {
    return label;
  } else {
    return "";
  }
}
export function getNextLevel(level) {
  let nextLevel = 0;
  let isHighest = false;
  if (level || level !== 0) {
    nextLevel = level + 1;
    if (nextLevel === 8) {
      isHighest = true;
    }
  }
  return {
    level: level,
    nextLevel: nextLevel,
    isHighest: isHighest
  };
}
