import Vue from "vue";
import VueRouter from "vue-router";

Vue.use(VueRouter);

const routes = [
  {
    path: "/my-status",
    name: "MyStatus",
    component: () => import("../views/my/myStatus.vue"),
    meta: { title: "我的直推" }
  },
  {
    path: "/publish",
    name: "Publish",
    component: () => import("@/views/moments/publish"),
    meta: { title: "发布资讯" }
  },
  {
    path: "/moments",
    name: "Moments",
    component: () => import("@/views/moments/moments"),
    meta: { title: "资讯", noNav: true }
  },
  {
    path: "/cash-out",
    name: "CashOut",
    component: () => import("@/views/cashOut/cash-out"),
    meta: { title: "提现" }
  },
  {
    path: "/cash-out-record",
    name: "CashOutRecord",
    component: () => import("@/views/cashOut/cash-out-record"),
    meta: { title: "提现记录" }
  },
  {
    path: "/bank",
    name: "Bank",
    component: () => import("@/views/bank"),
    meta: { title: "银行卡" }
  },
  {
    path: "/income",
    component: () => import("@/views/income/index"),
    children: [
      {
        path: "detail",
        name: "IncomeDetail",
        component: () => import("@/views/income/income-detail"),
        meta: { title: "收益明细查看" }
      },
      {
        path: "wallet",
        name: "Wallet",
        component: () => import("@/views/income/wallet"),
        meta: { title: "钱包" }
      },
      {
        path: "all",
        name: "AllIncomme",
        component: () => import("@/views/income/allIncome"),
        meta: { title: "累计收益" }
      }
    ]
  },
  {
    path: "/rewards",
    component: () => import("@/views/rewards/index"),
    children: [
      {
        path: "fastest-progress",
        name: "FastestProgress",
        component: () => import("@/views/rewards/fastest-progress"),
        meta: { title: "进步奖", noNav: true }
      },
      {
        path: "month-award",
        name: "MonthAward",
        component: () => import("@/views/rewards/month-award"),
        meta: { title: "月度奖励", noNav: true }
      }
    ]
  },
  {
    path: "/instructions",
    name: "Instructions",
    component: () => import("@/views/instructions"),
    meta: { title: "用户协议" }
  },
  {
    path: "/settings",
    name: "Settings",
    component: () => import("@/views/settings"),
    meta: { title: "设置" }
  },
  {
    path: "/modefy-avatar",
    name: "ModefyAvatar",
    component: () => import("@/views/modefyAvatar"),
    meta: { title: "更换头像" }
  },
  {
    path: "/grade",
    name: "Grade",
    component: () => import("@/views/grade"),
    meta: { title: "森林状态", noNav: true }
  },
  {
    path: "/leagueNums",
    name: "LeagueNums",
    component: () => import("@/views/leagueNums"),
    meta: { title: "团员总人数", noNav: true }
  },
  {
    path: "/canCashOut",
    name: "CanCashOut",
    component: () => import("@/views/canCashOut"),
    meta: { title: "可提现", noNav: true }
  },
  {
    path: "/airDrop",
    name: "AirDrop",
    component: () => import("@/views/airDropPool"),
    meta: { title: "空投池", noNav: true }
  },
  {
    path: "/",
    name: "Router",
    component: () => import("@/views/router"),
    meta: { title: "路径导航", noNav: true }
  },
  {
    path: "/register",
    name: "Register",
    component: () => import("@/views/register"),
    meta: { title: "注册", noNav: true }
  },
  {
    path: "/customer",
    name: "customerService",
    component: () => import("@/views/customer-service"),
    meta: { title: "专属客服", noNav: true }
  }
];

const router = new VueRouter({
  mode: "history",
  base: process.env.BASE_URL,
  routes
});

export default router;
