import axios from "axios";
import { Toast } from "vant";

let loading = null;

const service = axios.create({
  baseURL: "/shop-mall",
  // baseURL: "http://192.168.204.152:8997/shop-mall",
  timeout: 5000
});

service.interceptors.request.use(
  config => {
    config.headers["Authorization"] =
      "Bearer " + "b6cd4e221fdc4e46a6825c236c912fa6";
    if (!config.loading) {
      loading = Toast.loading({
        forbidClick: true,
        message: "加载中..."
      });
    }
    return config;
  },
  error => {
    if (loading) Toast.clear();
    console.log("rqquest====错误", error);
    console.log(error);
    this.$toast.fail(error.response.data.error);
  }
);

service.interceptors.response.use(
  response => {
    if (loading) Toast.clear();
    const res = response.data;
    return res;
  },
  error => {
    if (loading) Toast.clear();
    return Promise.reject(error);
  }
);

export default service;
