import request from "@/utils/request";

/**
 * 发布图文资讯
 * @param {*} params
 * @param {*} file 图片文件
 */
export function uploadImage(file) {
  return request({
    url: "/ZX/multipleImageUpload",
    method: "post",
    headers: { "Content-Type": "multipart/form-data" },
    data: file
  });
}

/**
 * 根据Id查找资讯
 * @param {*} params userId
 * @returns
 */
export function findByUserId(params) {
  return request({
    url: "/ZX/findByUserId",
    method: "get",
    params
  });
}
