import request from "@/utils/request";
import qs from "qs";
// 登录
export function Login() {
  return request({
    url: "/user/login?id=1",
    method: "get"
  });
}
/**
 * 发送验证码
 * @param {*} params userId  required 手机号
 * @param {*} param sms required 验证码
 * @param {*} param beInvitedCode required 邀请码
 * @returns
 */

export function register(params) {
  const final_params = qs.stringify(params);
  return request({
    url: "/api/user/register",
    method: "post",
    data: final_params
  });
}
/**
 * 填写邀请码
 * @param {*} params inviteCode
 * @param {*} params userId
 * @returns
 */
export function fillInviteCode(params) {
  return request({
    url: "/user/fillInInviteCode",
    method: "post",
    params
  });
}

/**
 * 设置头像
 * @param {*} param headImage 头像url
 * @param {*} param userId
 * @returns
 */

export function setAvatar(params) {
  return request({
    url: "/user/setHeadImage",
    method: "post",
    params
  });
}

/**
 * 退出
 * @param {*} token
 * @returns
 */
export function logout(token) {
  return request({
    url: "/api/user/logout",
    method: "post",
    header: { token: token }
  });
}

/**
 * 根据token获取userId
 * @param {*} params token
 */
export function getUserInfo() {
  return request({
    url: "/api/user/info",
    method: "post"
  });
}

/**
 * 获取用户信息
 * @param {*} params userId
 * @returns
 */
export function getUserInfo2(params) {
  return request({
    url: "/user/getByUserId",
    method: "get",
    params
  });
}
