package cn.wisenergy.chnmuseum.party.common.log;

public enum OperType {
    /**
     *
     */


    SELECT(1,"查询"),
    ADD(2,"新增"),
    UPDATE(3,"修改"),
    DELETE(4,"删除"),
    ENABLE(5,"启用"),
    DISABLE(6,"禁用"),
    IMPORT(7,"导入"),
    LOGIN(8,"登录"),
    AUDIT(9,"审核"),
    UPPER(10,"上架"),
    LOWER(11,"下架"),
    CHANGE_PASSWORD(12,"修改密码"),
    RESET_PASSWORD(13,"重置密码"),
    VIDEO_EXPORT(14,"视频汇出"),
    UPLOAD(15,"上传"),
    CHANGE_STYLE(16,"修改风格"),
    DETAILS(17,"详情"),
    ACTIVATION(18,"激活"),
    FAULT(19,"故障"),
    LOGOUT(21,"退出登录"),
    ;

    // 错误编码
    private Integer code;
    // 信息
    private String msg;

    // 相应编码有参构造函数
    OperType(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

}
