package cn.wisenergy.chnmuseum.party.common.mybatis;

import cn.wisenergy.chnmuseum.party.common.mybatis.query.InsertBatch;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.injector.DefaultSqlInjector;
import com.baomidou.mybatisplus.extension.injector.methods.AlwaysUpdateSomeColumnById;
import com.baomidou.mybatisplus.extension.injector.methods.InsertBatchSomeColumn;
import com.baomidou.mybatisplus.extension.injector.methods.LogicDeleteByIdWithFill;

import java.util.List;

/**
 * @author Danny Lee
 * @description 自定义sql注入器·
 * @date Created in 2020/3/6 16:10
 */
public class MyLogicSqlInjector extends DefaultSqlInjector {

    @Override
    public List<AbstractMethod> getMethodList(Class<?> mapperClass) {
        List<AbstractMethod> methodList = super.getMethodList(mapperClass);
        //增加自定义方法
        methodList.add(new InsertBatch());
        /*
         * 以下3个为内置选装件, 头2个支持字段筛选函数
         * 例: 不要指定了update填充的字段
         */
        methodList.add(new InsertBatchSomeColumn(i -> i.getFieldFill() != FieldFill.UPDATE));
        methodList.add(new AlwaysUpdateSomeColumnById(t -> !"name".equals(t.getColumn())));
        methodList.add(new LogicDeleteByIdWithFill());
        return methodList;
    }

}

