package cn.wisenergy.chnmuseum.party.common.vo;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.collections.CollectionUtils;

import java.time.LocalDate;
import java.util.Collections;
import java.util.List;

/**
 * 可排序查询参数对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("可排序查询参数对象")
public abstract class BasePageOrderParam extends BasePageParam {

    private static final long serialVersionUID = 57714391204790143L;

    @ApiModelProperty("名称/编码")
    private String nameOrCode;

    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("操作类型")
    private String operationType;

    @ApiModelProperty("起始修改时间")
    private LocalDate startDate;

    @ApiModelProperty("终止修改时间")
    private LocalDate endDate;

    @ApiModelProperty("排序")
    private List<OrderItem> pageSorts;

    @ApiModelProperty("创建人")
    private String creatorName;

    @ApiModelProperty("版权方类型")
    private String ownerType;

    @ApiModelProperty("视频内容分类ID")
    private String videoContentCatId;

    @ApiModelProperty("视频内容版权方ID")
    private String videoContentCopyrightOwnerId;

    @ApiModelProperty("展板版权方ID")
    private String boardCopyrightOwnerId;

    @ApiModelProperty(value = "禁用/启用")
    private Boolean isPublished;

    public void defaultPageSort(OrderItem orderItem) {
        this.defaultPageSorts(Collections.singletonList(orderItem));
    }

    public void defaultPageSorts(List<OrderItem> pageSorts) {
        if (CollectionUtils.isEmpty(pageSorts)) {
            return;
        }
        this.pageSorts = pageSorts;
    }

}
