package cn.wisenergy.chnmuseum.party.common.vo;

import cn.wisenergy.chnmuseum.party.model.Asset;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 批量操作响应结果
 *
 * @author mxy
 * @date 2020/4/22
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "批量操作响应参数", description = "批量操作响应参数")
public class BatchUploadResVO {

    private static final long serialVersionUID = 51873394122822866L;

    @ApiModelProperty("成功数量")
    private int successCount;

    @ApiModelProperty("失败数量")
    private int failureCount;

    @ApiModelProperty("操作总数")
    private int total;

    @ApiModelProperty("处理结果集合")
    private List<HandleResult> handleList;

    @ApiModelProperty("成功上传的文件集合")
    private List<Asset> fileList;

    @Data
    public static class HandleResult {

        @ApiModelProperty("名称")
        private String fileName;

        @ApiModelProperty("类型")
        private String fileType;

        @ApiModelProperty("文件URL")
        private String fileUrl;

        @ApiModelProperty("处理结果")
        private String handleResult;

        @ApiModelProperty("处理结果描述")
        private String description;

    }

}
