//package cn.wisenergy.chnmuseum.party.core.aop;
//
//import cn.wisenergy.chnmuseum.party.common.util.NetWorkUtil;
//import cn.wisenergy.chnmuseum.party.core.annotations.OperationLog;
//import cn.wisenergy.chnmuseum.party.web.controller.SysLogController;
//import org.apache.shiro.SecurityUtils;
//import org.aspectj.lang.JoinPoint;
//import org.aspectj.lang.ProceedingJoinPoint;
//import org.aspectj.lang.annotation.*;
//import org.aspectj.lang.reflect.MethodSignature;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Component;
//import org.springframework.transaction.annotation.Transactional;
//import org.springframework.web.context.request.RequestContextHolder;
//import org.springframework.web.context.request.ServletRequestAttributes;
//
//import javax.servlet.http.HttpServletRequest;
//import java.lang.reflect.Method;
//
//@Aspect
//@Component
//public class WebLogAspect {
//
//    private static final Logger LOGGER = LoggerFactory.getLogger(WebLogAspect.class);
//
//    @Autowired
//    private SysLogController sysLogController;
//
//    @Pointcut("execution (public * cn.wisenergy.chnmuseum.party.web.controller.*.*(..))")
//    public void methodCutPoint() {
//    }
//
//    @Before("methodCutPoint()")
//    public void doBefore() {
//        // 接收到请求，记录请求内容
//        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
//        HttpServletRequest request = attributes.getRequest();
//
//        LOGGER.info("URL : " + request.getRequestURL().toString());
//        LOGGER.info("HTTP_METHOD : " + request.getMethod());
//        LOGGER.info("IP : " + NetWorkUtil.getLoggableAddress(request));
//    }
//
//    // @After("methodCutPoint()")
//    public void doAfter() {
//        System.out.println("后面");
//    }
//
//    @AfterReturning(pointcut = "methodCutPoint()", returning = "result")
//    public void doAfterReturning(JoinPoint joinPoint, Object result) {
//        if(result != null){
//            // 处理完请求，返回内容
//            LOGGER.info("RESPONSE : " + result.toString());
//            // 这里记录日志 , 这里处理的内容会切入controller中
//        }
//
//    }
//
//    @Transactional
//    @Around("methodCutPoint()")
//    public Object doAroud(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
//
//        MethodSignature signature = (MethodSignature) proceedingJoinPoint.getSignature();
//        // 获取被拦截的方法
//        Method method = signature.getMethod();
//        if(isRecordLog(method) && isLogin()){
//            ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
//            HttpServletRequest request = attributes.getRequest();
//            //日志内容
//            String content = "";
//            //获取注解的值
//            OperationLog annotation = method.getAnnotation(OperationLog.class);
//            if(annotation != null){
//                content = annotation.value();
//            }
//            //插入到系统日志表
//            this.sysLogController.insertSysLog(content,null);
//        }
//
//        return proceedingJoinPoint.proceed();
//    }
//
//    /**
//     * 判断这个方法是否需要记录日志
//     * @param method
//     * @return
//     */
//    private boolean isRecordLog(Method method) {
//        boolean result = false;
//        if (method.isAnnotationPresent(OperationLog.class)) {
//            result = true;
//        }
//        return result;
//    }
//
//    /**
//     * 判断是否已经登录
//     * @return
//     */
//    private boolean isLogin() {
//        return SecurityUtils.getSubject().getPrincipal() != null;
//    }
//
//}