package cn.wisenergy.chnmuseum.party.mapper;

import cn.wisenergy.chnmuseum.party.model.Audit;
import cn.wisenergy.chnmuseum.party.model.TUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <pre>
 * 学习内容信息 Mapper 接口
 * </pre>
 *
 * @author Danny Lee
 * @since 2021-03-26
 */
public interface AuditMapper extends BaseMapper<Audit> {

    List<Audit> getUserList(Page<Audit> page, @Param("user") TUser user);

    /**
     * 视频内容审核分页
     *
     * @param page
     * @param wrapper
     * @return
     */
    Page<Audit> getVideoContentPage(Page<Audit> page, @Param(Constants.WRAPPER) Wrapper<Audit> wrapper);

    /**
     * 展板审核分页
     *
     * @param page
     * @param wrapper
     * @return
     */
    Page<Audit> getExhibitionBoardPage(Page<Audit> page, @Param(Constants.WRAPPER) Wrapper<Audit> wrapper);

    /**
     * 平台学习内容审核分页
     *
     * @param page
     * @param wrapper
     * @return
     */
    Page<Audit> getLearningContentPage(Page<Audit> page, @Param(Constants.WRAPPER) Wrapper<Audit> wrapper);

}
