package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 看板播放排行
 * </p>
 *Ø
 * @author Danny Lee
 * @since 2021-03-20
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("board_play_rank")
@ApiModel(value = "展板播放排行", description = "展板播放排行")
public class BoardPlayRank implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value ="ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "IDID不能为空")
    private String id;

    @ApiModelProperty(value ="看板ID")
    @TableField("board_id")
        @NotBlank(message = "看板ID不能为空", groups = {Add.class})
        private String boardId;
    
    @ApiModelProperty(value ="看板名称")
    @TableField("board_name")
        @NotBlank(message = "看板名称不能为空", groups = {Add.class})
        private String boardName;
    
    @ApiModelProperty(value ="播放次数")
    @TableField("play_number")
    private Integer playNumber;
    
    @ApiModelProperty(value ="年")
    @TableField("year")
    private String year;
    
    @ApiModelProperty(value ="月")
    @TableField("month")
    private String month;
    



}
