package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 版权方展板分类
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-18
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("copyright_owner_board_type")
@ApiModel(value = "版权方展板分类", description = "版权方展板分类")
public class CopyrightOwnerBoardType implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "ID不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("版权方ID")
    @TableField("copyright_owner_id")
    @NotBlank(message = "版权方ID不能为空", groups = {Add.class, Update.class})
    private String copyrightOwnerId;

    @ApiModelProperty("展板分类ID")
    @TableField("board_type_id")
    @NotBlank(message = "展板分类ID不能为空", groups = {Add.class, Update.class})
    private String boardTypeId;

}
