package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.update.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * <p>
 * 看板播放排行
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-20
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("district_board_statistic")
@ApiModel(value = "地区展板播放统计", description = "地区展板播放统计")
public class DistrictBoardStatistic implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "IDID不能为空")
    private String id;

    @ApiModelProperty("看板ID")
    @TableField("board_id")
        @NotBlank(message = "看板ID不能为空", groups = {Add.class, Update.class})
        private String boardId;
    
    @ApiModelProperty("看板名称")
    @TableField("board_name")
        @NotBlank(message = "看板名称不能为空", groups = {Add.class, Update.class})
        private String boardName;
    
    @ApiModelProperty("播放次数")
    @TableField("play_number")
    private Integer playNumber;
    
    @ApiModelProperty("年")
    @TableField("year")
    private String year;
    
    @ApiModelProperty("月")
    @TableField("month")
    private String month;
    



}
