package cn.wisenergy.chnmuseum.party.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;

/**
 * <p>
 * 组织成员
 * </p>
 *
 * @author 杨智平
 * @since 2018-08-02
 */
@TableName("employee")
public class Employee extends Model<Employee> {

    private static final long serialVersionUID = 1L;

    public Employee() {
    }

    public Employee(String jwtToken) {
        this.jwtToken = jwtToken;
    }

    public Employee(String id, String jwtToken) {
        this.id = id;
        this.jwtToken = jwtToken;
    }

    @TableField(exist = false)
    private String jwtToken;
    /**
     * 用户标识
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;
    /**
     * 用户名
     */
    @ApiModelProperty("用户名")
    private String username;
    /**
     * 密码
     */
    @ApiModelProperty("密码")
    @JSONField(serialize = false)
    @TableField(exist = false)
    private String password;
    /**
     * 密码
     */
    @TableField("password_hash")
    @JSONField(serialize = false)
    private byte[] passwordHash;

    @TableField("password_salt")
    @JSONField(serialize = false)
    private byte[] passwordSalt;
    /**
     *
     */
    @ApiModelProperty("员工号")
    @TableField("code")
    private String code;
    /**
     * 姓名
     */
    @ApiModelProperty("姓名")
    @TableField("name")
    private String name;
    /**
     * 个人头像
     */
    @ApiModelProperty("个人头像")
    private String avatar;
    /**
     * 默认：男
     */
    @ApiModelProperty("性别：1-男0-女")
    private Integer sex;

    @ApiModelProperty("身份证号")
    @TableField("id_number")
    private String idNumber;
    /**
     * 手机号
     */
    @ApiModelProperty("手机号")
    private String mobile;
    /**
     * 邮箱
     */
    @ApiModelProperty("邮箱")
    private String email;
    /**
     * 1-启用2禁用
     */
    @ApiModelProperty("状态:1-启用0-禁用")
    private Boolean status;
    /**
     * 排序号
     */
    @ApiModelProperty("排序号")
    private Integer sortorder;
    /**
     * 创建时间
     */
    @TableField("create_time")
    private Date createTime;
    /**
     * 修改时间
     */
    @TableField("update_time")
    private Date updateTime;
    /**
     * 0：未删除，1：已删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 所属支行ID
     */
    @ApiModelProperty("所属支行ID")
    @TableField("bank_branch_id")
    private String bankBranchId;

    @ApiModelProperty("所属支行名称")
    @TableField(exist = false)
    private String bankBranchName;

    @ApiModelProperty("是否允许登录")
    @TableField(exist = false)
    private Boolean isAllowLogin;

    @ApiModelProperty("角色ID")
    @TableField(exist = false)
    private String roleId;
    @TableField(exist = false)
    private String roleName;
    @TableField(exist = false)
    private BankBranchInfo bankBranchInfo;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public byte[] getPasswordHash() {
        return passwordHash;
    }

    public void setPasswordHash(byte[] passwordHash) {
        this.passwordHash = passwordHash;
    }

    public byte[] getPasswordSalt() {
        return passwordSalt;
    }

    public void setPasswordSalt(byte[] passwordSalt) {
        this.passwordSalt = passwordSalt;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public String getIdNumber() {
        return idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Boolean getStatus() {
        return status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public Integer getSortorder() {
        return sortorder;
    }

    public void setSortorder(Integer sortorder) {
        this.sortorder = sortorder;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getIsDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public String getJwtToken() {
        return jwtToken;
    }

    public void setJwtToken(String jwtToken) {
        this.jwtToken = jwtToken;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getBankBranchId() {
        return bankBranchId;
    }

    public void setBankBranchId(String bankBranchId) {
        this.bankBranchId = bankBranchId;
    }

    public BankBranchInfo getBankBranchInfo() {
        return bankBranchInfo;
    }

    public void setBankBranchInfo(BankBranchInfo bankBranchInfo) {
        this.bankBranchInfo = bankBranchInfo;
    }

    public String getBankBranchName() {
        return bankBranchName;
    }

    public void setBankBranchName(String bankBranchName) {
        this.bankBranchName = bankBranchName;
    }

    public Boolean getAllowLogin() {
        return isAllowLogin;
    }

    public void setAllowLogin(Boolean allowLogin) {
        isAllowLogin = allowLogin;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "Employee{" +
                "jwtToken='" + jwtToken + '\'' +
                ", id='" + id + '\'' +
                ", username='" + username + '\'' +
                ", password='" + password + '\'' +
                ", passwordHash=" + Arrays.toString(passwordHash) +
                ", passwordSalt=" + Arrays.toString(passwordSalt) +
                ", code='" + code + '\'' +
                ", name='" + name + '\'' +
                ", avatar='" + avatar + '\'' +
                ", sex=" + sex +
                ", idNumber='" + idNumber + '\'' +
                ", mobile='" + mobile + '\'' +
                ", email='" + email + '\'' +
                ", status=" + status +
                ", sortorder=" + sortorder +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", isDeleted=" + isDeleted +
                ", bankBranchId='" + bankBranchId + '\'' +
                ", roleId='" + roleId + '\'' +
                ", roleName='" + roleName + '\'' +
                '}';
    }
}
