package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 展板
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-17
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("exhibition_board")
@ApiModel(value = "展板内容", description = "展板内容")
public class ExhibitionBoard implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("展板内容ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "展板内容ID不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("展板分类名称")
    @TableField("name")
    @NotBlank(message = "展板分类名称不能为空", groups = {Add.class, Update.class})
    private String name;

    @ApiModelProperty("展板编号")
    @TableField(value = "serial_no")
    private String serialNo;

    @ApiModelProperty("展板版权方ID")
    @TableField("board_copyright_owner_id")
    private String boardCopyrightOwnerId;

    @ApiModelProperty("展板分类ID")
    @TableField("exhibition_board_cat_id")
    private String exhibitionBoardCatId;

    @ApiModelProperty("展板图片URL")
    @TableField("cover")
    @NotBlank(message = "展板图片URL不能为空", groups = {Add.class, Update.class})
    private String cover;

    @ApiModelProperty("展板二维码URL")
    @TableField("qrcode_url")
    @NotBlank(message = "展板二维码URL不能为空", groups = {Add.class, Update.class})
    private String qrcodeUrl;

    @ApiModelProperty("简介")
    @TableField("remarks")
    @NotBlank(message = "简介不能为空", groups = {Add.class, Update.class})
    private String remarks;

    @ApiModelProperty("视频内容版权方ID")
    @TableField("video_content_copyright_owner_id")
    @NotBlank(message = "视频内容版权方ID不能为空", groups = {Add.class, Update.class})
    private String videoContentCopyrightOwnerId;

    @ApiModelProperty("视频内容类别ID")
    @TableField("video_content_cat_id")
    @NotBlank(message = "视频内容类别ID不能为空", groups = {Add.class, Update.class})
    private String videoContentCatId;

    @ApiModelProperty("视频内容ID")
    @TableField("video_content_id")
    @NotBlank(message = "视频内容ID不能为空", groups = {Add.class, Update.class})
    private String videoContentId;

    @ApiModelProperty("参考资料文件夹")
    @TableField("ref_material_dir")
    private String refMaterialDir;

    @ApiModelProperty("审核状态")
    @TableField("audit_status")
    private String auditStatus;

    @ApiModelProperty("是否上架")
    @TableField("is_published")
    private Boolean published;

    @ApiModelProperty("是否已删除")
    @TableField("is_deleted")
    private Boolean deleted;

    @ApiModelProperty("创建日期")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    @ApiModelProperty("修改日期")
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updateTime;

    @ApiModelProperty("展板音频文件ID列表(添加或更新使用)")
    @TableField(exist = false)
    private List<String> audioIdList;

    @ApiModelProperty("参考资料文件ID列表(添加或更新使用)")
    @TableField(exist = false)
    private List<String> datumIdList;

    @ApiModelProperty("展板视频缩略图")
    @TableField(exist = false)
    private String boardVideoContentThumbnail;

    @ApiModelProperty("所属学习内容ID")
    @TableField(exist = false)
    private String learningContentId;

    @ApiModelProperty("展板版权方名称")
    @TableField(exist = false)
    private String boardCopyrightOwnerName;

    @ApiModelProperty("展板分类名称")
    @TableField(exist = false)
    private String exhibitionBoardCatName;

    @ApiModelProperty("视频资料-视频内容版权方名称")
    @TableField(exist = false)
    private String videoContentCopyrightOwnerName;

    @ApiModelProperty("视频资料-视频内容分类名称")
    @TableField(exist = false)
    private String videoContentCatName;

    @ApiModelProperty("视频资料-视频内容名称")
    @TableField(exist = false)
    private String videoContentName;

    @ApiModelProperty("展板视频")
    @TableField(exist = false)
    private List<Asset> videoList;

    @ApiModelProperty("展板视频")
    @TableField(exist = false)
    private List<Asset> audioList;

    @ApiModelProperty("参考资料列表")
    @TableField(exist = false)
    private List<Asset> datumList;

    @ApiModelProperty("审核意见记录")
    @TableField(exist = false)
    private List<Audit> auditHistoryList;

}
