package cn.wisenergy.chnmuseum.party.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 网点热点区域表
 * </p>
 *
 * @author 杨智平
 * @since 2018-08-29
 */
@TableName("hot_spot")
public class HotSpot extends Model<HotSpot> {

    private static final long serialVersionUID = 1L;

    /**
     * 唯一标识
     */
    @ApiModelProperty("唯一标识")
    @TableId(value = "id", type = IdType.UUID)
    private String id;
    /**
     * 所属网点ID
     */
    @ApiModelProperty("所属网点ID")
    @TableField("bank_branch_id")
    private String bankBranchId;
    /**
     * 热点名称
     */
    @ApiModelProperty("热点名称")
    private String name;
    /**
     * 热点备注
     */
    @ApiModelProperty("热点备注")
    private String note;
    /**
     * 热点坐标，可以是点，线，或者面
     */
    @ApiModelProperty("热点坐标，可以是点，线，或者面")
    private String coordinate;
    /**
     * 热点宽度
     */
    @ApiModelProperty("热点宽度")
    private String width;
    /**
     * 热点高度
     */
    @ApiModelProperty("热点高度")
    private String height;
    /**
     * 旋转角度
     */
    @ApiModelProperty("旋转角度")
    @TableField("rotation_angle")
    private String rotationAngle;

    /**
     * 热点类型
     */
    @ApiModelProperty("热点类型  Point   polygon")
    @TableField("type")
    private String type;

    /**
     * 热点图标地址
     */
    @ApiModelProperty("热点图标地址")
    @TableField("image_url")
    private String imageUrl;



    /**
     * 创建时间
     */
    @ApiModelProperty(hidden = true)
    @TableField("create_time")
    private Date createTime;
    /**
     * 修改时间
     */
    @ApiModelProperty(hidden = true)
    @TableField("update_time")
    private Date updateTime;





    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBankBranchId() {
        return bankBranchId;
    }

    public void setBankBranchId(String bankBranchId) {
        this.bankBranchId = bankBranchId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getCoordinate() {
        return coordinate;
    }

    public void setCoordinate(String coordinate) {
        this.coordinate = coordinate;
    }

    public String getWidth() {
        return width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getRotationAngle() {
        return rotationAngle;
    }

    public void setRotationAngle(String rotationAngle) {
        this.rotationAngle = rotationAngle;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }


    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Override
    public String toString() {
        return "HotSpot{" +
                ", id=" + id +
                ", bankBranchId=" + bankBranchId +
                ", name=" + name +
                ", note=" + note +
                ", coordinate=" + coordinate +
                ", width=" + width +
                ", height=" + height +
                ", rotationAngle=" + rotationAngle +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", imageUrl=" + imageUrl +
                ", type=" + type +
                "}";
    }
}
