package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 互动排行
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-20
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("interaction_rank")
@ApiModel(value = "互动频次", description = "互动频次")
public class InteractionRank implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "ID不能为空")
    private String id;

    @ApiModelProperty("机构id")
    @TableField("organ_id")
    private String organId;
    
    @ApiModelProperty("机构名称")
    @TableField("organ_name")
        @NotBlank(message = "机构名称不能为空", groups = {Add.class})
        private String organName;
    
    @ApiModelProperty("互动次数")
    @TableField("number")
    private Integer number;
    
    @ApiModelProperty("创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
        @NotNull(message = "创建时间不能为空", groups = {Add.class})
        private LocalDateTime createTime;
    



}
