package cn.wisenergy.chnmuseum.party.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户/平台操作日志
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_sys_log")
@ApiModel(value = "SysLog对象", description = "用户/平台操作日志")
public class SysLog implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "操作日志ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "操作者")
    @TableField("operator")
    private String operator;

    @ApiModelProperty(value = "操作类型")
    @TableField("operation_type")
    private String operationType;

    @ApiModelProperty(value = "操作对象")
    @TableField("operation_object")
    private String operationObject;

    @ApiModelProperty(value = "操作内容")
    @TableField("operation_content")
    private String operationContent;

    @ApiModelProperty(value = "操作时间")
    @TableField("operation_time")
    private LocalDateTime operationTime;

    @ApiModelProperty(value = "远程IP")
    @TableField("operation_ip")
    private String operationIp;

    @ApiModelProperty(value = "日志类型 1.平台操作日志  2.用户操作日志")
    @TableField("type")
    private Integer type;

}
