package cn.wisenergy.chnmuseum.party.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import javax.validation.constraints.NotNull;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;

/**
 * <p>
 *
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-29
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("t_app_version")
@ApiModel(value = "", description = "")
public class TAppVersion implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键id")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "主键id不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("APP版本号")
    @TableField("app_version")
    private String appVersion;

    @ApiModelProperty("是否为当前版本 0：否  1：是")
    @TableField("is_current")
    private Integer isCurrent;

    @ApiModelProperty("创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    @ApiModelProperty("更新时间")
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updateTime;

    @ApiModelProperty("操作人id")
    @TableField("user_id")
    private String userId;

    @ApiModelProperty("操作员")
    @TableField("user_name")
    private String userName;

    @ApiModelProperty("安装包路径")
    @TableField("apk_url")
    private String apkUrl;

    @ApiModelProperty("版本信息")
    @TableField("version_info")
    private String versionInfo;

    @ApiModelProperty("更新日志")
    @TableField("update_log")
    private String updateLog;

}
