package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * <p>
 * 看板互动
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-23
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("t_interaction")
@ApiModel(value = "看板互动", description = "看板互动")
public class TInteraction implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "idID不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("机构id")
    @TableField("organ_id")
    private String organId;

    @ApiModelProperty("帐户名")
    @TableField("username")
    @NotBlank(message = "帐户名不能为空", groups = {Add.class, Update.class})
    private String username;

    @ApiModelProperty("展板ID")
    @TableField("board_id")
    private String boardId;

    @ApiModelProperty("学习时间")
    @TableField(value = "study_time", fill = FieldFill.INSERT)
    @NotNull(message = "创建时间不能为空", groups = {Add.class, Update.class})
    private LocalDateTime studyTime;

    @ApiModelProperty("观影人数")
    @TableField("num")
    private Integer num;

    @ApiModelProperty("内容")
    @TableField("content")
    private String content;

    @ApiModelProperty("图片信息")
    @TableField("images")
    private String images;

    @ApiModelProperty("创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @NotNull(message = "创建时间不能为空", groups = {Add.class, Update.class})
    private LocalDateTime createTime;


    @ApiModelProperty("管理员账号")
    @TableField(exist = false)
    @NotNull(message = "管理员账号不能为空", groups = {Add.class})
    private String name;

    @ApiModelProperty("密码")
    @TableField(exist = false)
    @NotNull(message = "密码不能为空", groups = {Add.class})
    private String password;


    @ApiModelProperty("展板名称")
    @TableField(exist = false)
    private String boardName;
}
