package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import com.baomidou.mybatisplus.annotation.TableField;

/**
 * <p>
 * 用户角色关联
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-22
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("t_user_role_link")
@ApiModel(value = "用户角色关联", description = "用户角色关联")
public class TUserRole implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "IDID不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("用户名")
    @TableField("user_id")
        @NotBlank(message = "用户名不能为空", groups = {Add.class, Update.class})
        private String userId;
    
    @TableField("role_id")
        @NotBlank(message = "不能为空", groups = {Add.class, Update.class})
        private String roleId;
    
    @ApiModelProperty("0：未删除，1：已删除")
    @TableField("is_deleted")
    private Boolean isDeleted;
    



}
