package cn.wisenergy.chnmuseum.party.service;

import cn.wisenergy.chnmuseum.party.common.enums.AuditOperationEnum;
import cn.wisenergy.chnmuseum.party.common.enums.AuditStatusEnum;
import cn.wisenergy.chnmuseum.party.common.enums.AuditTypeEnum;
import cn.wisenergy.chnmuseum.party.model.Audit;
import cn.wisenergy.chnmuseum.party.model.TUser;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;

/**
 * <p>
 * 学习内容信息 服务接口
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-26
 */
public interface AuditService extends IService<Audit> {

    Page<Audit> getUserList(Page<Audit> page, TUser user);

    /**
     * 分页查询
     *
     * @param name
     * @param status
     * @param auditStatusLevel
     * @param type
     * @param page
     * @return
     */
    Page<Audit> pageList(String name, AuditStatusEnum status, AuditStatusEnum auditStatusLevel, AuditTypeEnum type, Page<Object> page);

    /**
     * 根据id更新审核信息
     *
     * @param audit
     * @return
     */
    boolean updateAuditAllById(Audit audit);

    Audit selectOne(String id, String type);

    /**
     * 根据审核项数据插入审核记录
     *
     * @param refItemId     审核项ID
     * @param content       审核内容
     * @param typeEnum      审核类型
     * @param operationEnum 操作类型
     * @return
     */
    boolean saveByRefItemInfo(String refItemId, String content,
                              AuditTypeEnum typeEnum,
                              AuditOperationEnum operationEnum);
}
