package cn.wisenergy.chnmuseum.party.service.impl;

import cn.wisenergy.chnmuseum.party.common.enums.AuditOperationEnum;
import cn.wisenergy.chnmuseum.party.common.enums.AuditStatusEnum;
import cn.wisenergy.chnmuseum.party.mapper.TAreaMapper;
import cn.wisenergy.chnmuseum.party.model.TUser;
import cn.wisenergy.chnmuseum.party.mapper.TUserMapper;
import cn.wisenergy.chnmuseum.party.service.TUserService;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * <pre>
 * 用户 服务实现类
 * </pre>
 *
 * @author Danny Lee
 * @since 2021-03-22
 */
@Slf4j
@Service
public class TUserServiceImpl extends ServiceImpl<TUserMapper, TUser> implements TUserService {

    @Resource
    private TUserMapper tUserMapper;

    @Resource
    private TAreaMapper areaMapper;

    @Override
    public TUser selectByUsername(String userName) {
        return tUserMapper.selectByUsername(userName);
    }

    @Override
    public Page<TUser> getList(Page<TUser> page, TUser user) {
        List<TUser> list = tUserMapper.getList(page,user);
        for (TUser u : list) {
            if (AuditStatusEnum.REFUSED.name().equals(u.getAuditStatus())||AuditStatusEnum.APPROVED_FINAL.name().equals(u.getAuditStatus())){
                if (AuditOperationEnum.ENABLE.name().equals(u.getStatus())){
                    u.setStatusName("活跃");
                }else {
                    u.setStatusName("禁用");
                }
            }else {
                u.setStatusName("待审核");
            }
        }
        return page.setRecords(list);
    }

    @Override
    public TUser selectById(String id) {
        TUser user = tUserMapper.getById(id);
        if (user.getAreaId()!=null) {
            String s = areaMapper.selectParent(user.getAreaId());
            user.setAreas(Arrays.asList(s.split(",")));
        }
        return user;
    }

    @Override
    public List<TUser> getUserList(TUser user) {
        List<TUser> list = tUserMapper.getUserList(user);
        return list;
    }

}
