package cn.wisenergy.chnmuseum.party.service.impl;

import cn.wisenergy.chnmuseum.party.common.dfs.FastDFSUtils;
import com.baidu.ueditor.define.AppInfo;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.MultiState;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.extend.UeditorService;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

/**
 * UeditorService的FastDFS实现
 */
@Service
public class UeditorServiceFastdfsImpl implements UeditorService {

    @Override
    public com.baidu.ueditor.extend.MultipartFile getMultipartFile(String filedName, HttpServletRequest request) {
        com.baidu.ueditor.extend.MultipartFile resultFile = null;
        try {
            MultipartHttpServletRequest multipartHttpservletRequest = (MultipartHttpServletRequest) request;
            MultipartFile multipartFile = multipartHttpservletRequest.getFile(filedName);
            if (multipartFile != null && !multipartFile.isEmpty()) {
                resultFile = new com.baidu.ueditor.extend.StandardMultipartFile(filedName, multipartFile.getInputStream(),
                        multipartFile.getOriginalFilename(), multipartFile.getSize());
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return resultFile;
    }

    @Override
    public State saveFileByInputStream(com.baidu.ueditor.extend.MultipartFile multipartFile, long maxSize) {
        State state;
        try {
            if (multipartFile.getSize() > maxSize) {
                return new BaseState(false, AppInfo.MAX_SIZE);
            }
            Map<String, Object> uploadResult;
            String originalFileName = multipartFile.getOriginalFilename();
            uploadResult = FastDFSUtils.uploadUeImage(multipartFile.getInputStream(), multipartFile.getSize(), originalFileName);
            if ((Boolean) uploadResult.get("status")) {
                state = new BaseState(true);
                state.putInfo("size", uploadResult.get("size").toString());
                state.putInfo("title", uploadResult.get("title").toString());
                state.putInfo("url", uploadResult.get("url").toString());
                return state;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return new BaseState(false, AppInfo.IO_ERROR);
    }

    @Override
    public State saveBinaryFile(InputStream inputStream, long fileSize, String fileName) {
        State state;

        Map<String, Object> uploadResult = FastDFSUtils.uploadUeImage(inputStream, fileSize, fileName);
        if ((Boolean) uploadResult.get("status")) {
            state = new BaseState(true);
            state.putInfo("size", uploadResult.get("size").toString());
            state.putInfo("title", uploadResult.get("title").toString());
            state.putInfo("url", uploadResult.get("url").toString());
            // 把上传的文件信息记入数据库
            return state;
        }

        return new BaseState(false, AppInfo.IO_ERROR);
    }

    @Override
    public State saveBinaryFile(byte[] data, String fileName) {
        State state;

        ByteArrayInputStream baos = new ByteArrayInputStream(data);
        Map<String, Object> uploadResult = FastDFSUtils.uploadUeImage(baos, 0L, fileName);
        if ((Boolean) uploadResult.get("status")) {
            state = new BaseState(true);
            state.putInfo("size", uploadResult.get("size").toString());
            state.putInfo("title", uploadResult.get("title").toString());
            state.putInfo("url", uploadResult.get("url").toString());
            // 把上传的文件信息记入数据库
            return state;
        }

        return new BaseState(false, AppInfo.IO_ERROR);
    }

    @Override
    public State listFile(String[] allowFiles, int start, int pageSize) {
        // 把计入数据库中的文件信息读取出来，返回即可

        // 下面的代码，仅作示例
        State state = new MultiState(true);
        state.putInfo("start", start);
        state.putInfo("total", 0);
        return state;
    }
}
