package cn.wisenergy.chnmuseum.party.web.controller;

import cn.wisenergy.chnmuseum.party.common.vo.GenericPageParam;
import cn.wisenergy.chnmuseum.party.model.Asset;
import cn.wisenergy.chnmuseum.party.service.AssetService;
import cn.wisenergy.chnmuseum.party.web.controller.base.BaseController;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * <pre>
 * 文件资产 前端控制器
 * </pre>
 *
 * @author Danny Lee
 * @since 2021-04-06
 */
@Slf4j
@RestController
@RequestMapping("/asset")
@Api(tags = {"文件资产操作接口"})
public class AssetController extends BaseController {

    @Resource
    private AssetService assetService;

    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "nameOrCode", value = "视频文件名", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "videoContentCatId", value = "视频内容分类ID", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "videoContentCopyrightOwnerId", value = "视频内容版权方ID", paramType = "query", dataType = "String")
    })
    @PostMapping("/getPageList")
    @RequiresPermissions("asset:page")
    @ApiOperation(value = "获取视频汇出分页列表", notes = "获取视频汇出分页列表")
    public Map<String, Object> getAssetPageList(GenericPageParam genericPageParam,
                                                @RequestParam(value = "videoContentCatId", required = false) String videoContentCatId,
                                                @RequestParam(value = "videoContentCopyrightOwnerId", required = false) String videoContentCopyrightOwnerId) {
        LambdaQueryWrapper<Asset> ew = new LambdaQueryWrapper<>();
        // 对名称或编码模糊查询
        if (StringUtils.isNotBlank(genericPageParam.getNameOrCode())) {
            ew.like(Asset::getFileName, genericPageParam.getNameOrCode());
        }
        // 设置排序规则
        ew.orderByDesc(Asset::getCreateTime);
        Page<Asset> page = this.assetService.pageByConditions(getPage(), videoContentCatId, videoContentCopyrightOwnerId);
        return getResult(page);
    }

    @ApiOperation(value = "获取视频文件详情", notes = "获取视频文件详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "标识ID", dataType = "String", paramType = "path")
    })
    @GetMapping("/get/{id}")
    @RequiresPermissions("asset:get:id")
    public Map<String, Object> getById(@PathVariable("id") String id) {
        Asset asset = assetService.getById(id);
        return getResult(asset);
    }

    @ApiOperation(value = "视频文件汇出", notes = "视频文件汇出")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "idList", value = "视频文件标识ID集合", dataType = "String", paramType = "path")
    })
    @PostMapping("/download")
    @RequiresPermissions("asset:download")
    public void download(@RequestParam("idList") List<String> idList) {
        final List<Asset> assetList = assetService.listByIds(idList);



    }

}

