package cn.wisenergy.chnmuseum.party.web.controller;

import cn.wisenergy.chnmuseum.party.common.enums.AuditOperationEnum;
import cn.wisenergy.chnmuseum.party.common.enums.AuditStatusEnum;
import cn.wisenergy.chnmuseum.party.common.enums.AuditTypeEnum;
import cn.wisenergy.chnmuseum.party.common.log.MethodLog;
import cn.wisenergy.chnmuseum.party.common.log.OperModule;
import cn.wisenergy.chnmuseum.party.common.log.OperType;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import cn.wisenergy.chnmuseum.party.common.vo.AuditStatusParam;
import cn.wisenergy.chnmuseum.party.model.Audit;
import cn.wisenergy.chnmuseum.party.model.TUser;
import cn.wisenergy.chnmuseum.party.service.impl.AuditServiceImpl;
import cn.wisenergy.chnmuseum.party.service.impl.TUserServiceImpl;
import cn.wisenergy.chnmuseum.party.web.controller.base.BaseController;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

/**
 * <pre>
 * 禁用审核 前端控制器
 * </pre>
 *
 * @author Danny Lee
 * @since 2021-03-26
 */
@Slf4j
@RestController
@RequestMapping("/audit")
@Api(tags = {"审核管理操作接口"})
@Validated
public class AuditController extends BaseController {

    @Resource
    private AuditServiceImpl auditService;

    @Resource
    private TUserServiceImpl userService;

    @GetMapping("/getUserList")
    @RequiresPermissions("/audit/getUserList")
    @ApiOperation(value = "获取用户禁用审核列表", notes = "获取用户禁用审核列表")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "name", value = "账号名称或提交人", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "name", value = "账号名称或提交人", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "status", value = "TBC,REFUSED,TBCA,APPROVED_FINAL", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "level", value = "TBC,TBCA", paramType = "query", dataType = "String")
    })
    @MethodLog(operModule = OperModule.RECHECK,operType = OperType.SELECT)
    public Map<String, Object> getUserList(String name, String status, String level) {
        Page<Audit> auditList;
        try {
            TUser user1 = getcurUser();
            TUser user = new TUser();
            if (StringUtils.isNotBlank(name)) {
                user.setUserName(name);
            }
            if (StringUtils.isNotBlank(status)) {
                user.setStatus(status);
            }
            if (StringUtils.isNotBlank(level)) {
                user.setAuditStatus(level);
            }
            //如果是账号禁用初审员，设置层级为初审
            if (user1.getRoleList().contains("15")) {
                user.setAuditStatus(AuditStatusEnum.TBC.name());
            } else if (user1.getRoleList().contains("16")) {
                user.setAuditStatus(AuditStatusEnum.TBCA.name());
            } else {
                //不存在的层级
                user.setAuditStatus("1");
            }
            auditList = auditService.getUserList(getPage(), user);
            return getResult(auditList);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return getFailResult();
    }

    @PutMapping("/update")
    @RequiresPermissions("/audit/update")
    @ApiOperation(value = "修改禁用审核信息", notes = "修改禁用审核信息")
    @MethodLog(operModule = OperModule.RECHECK,operType = OperType.AUDIT)
    public Map<String, Object> updateAudit(@RequestBody @Validated(value = {Update.class}) Audit audit) {
        boolean flag;
        //如果层级是初审，设置初审时间
        if (AuditStatusEnum.TBC.name().equals(audit.getLevel())) {
            audit.setFirstTime(LocalDateTime.now());
            //如果审核状态不是驳回，清空驳回原因
            if (!AuditStatusEnum.REFUSED.name().equals(audit.getStatus())) {
                audit.setFirstRemarks("");
            }
        } else {
            //如果层级是复审，设置复审时间
            audit.setSecondTime(LocalDateTime.now());
            //如果审核状态不是驳回，清空驳回原因
            if (!AuditStatusEnum.REFUSED.name().equals(audit.getStatus())) {
                audit.setSecondRemarks("");
            }
        }
        //如果当前审核状态为通过，并且审核层级为初审
        if (AuditStatusEnum.APPROVED_FINAL.name().equals(audit.getStatus()) && AuditStatusEnum.TBC.name().equals(audit.getLevel())) {
            //初审通过，提交复审，设置层级为复审
            audit.setLevel(AuditStatusEnum.TBCA.name());
            audit.setStatus(AuditStatusEnum.TBCA.name());
        }
        try {
            //如果类型是用户禁用审核
            if (AuditTypeEnum.ACCOUNT.name().equals(audit.getType())) {
                //设置用户原始数据状态
                TUser user = userService.getById(audit.getRefItemId());
                //无论初审复审，及时更新审核状态
                user.setAuditStatus(audit.getStatus());
                //如果复审通过，真正禁用用户
                if (AuditStatusEnum.APPROVED_FINAL.name().equals(audit.getStatus()) && AuditStatusEnum.TBCA.name().equals(audit.getLevel())) {
                    user.setStatus(AuditOperationEnum.DISABLE.name());
                }
                userService.updateById(user);
            }
            //更新审核数据
            flag = auditService.updateById(audit);
            if (!flag) {
                return getFailResult();
            }
            return getSuccessResult();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return getFailResult();
    }

    @DeleteMapping("/delete/{id}")
    @RequiresPermissions("/audit/delete")
    @ApiOperation(value = "根据ID删除禁用审核", notes = "根据ID删除禁用审核")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "id", value = "标识ID", paramType = "path", dataType = "String")
    })
    public Map<String, Object> deleteAudit(@PathVariable("id") String id) {
        boolean result = auditService.removeById(id);
        if (result) {
            return getSuccessResult();
        }
        return getFailResult();
    }

//    @GetMapping("/getList")
//    @RequiresPermissions("/audit/getList")
//    @ApiOperation(value = "获取禁用审核全部列表(无分页)", notes = "获取禁用审核全部列表(无分页)")
//    @ApiImplicitParams(value = {
//            @ApiImplicitParam(name = "auditStatus", value = "审核状态", paramType = "query", dataType = "String")
//    })
//    public Map<String, Object> getAuditList(@RequestParam(value = "auditStatus", defaultValue = "APPROVED_FINAL", required = false) AuditStatusEnum auditStatus) {
//        List<Audit> auditList = auditService.list();
//        return getResult(auditList);
//    }
//
//    @ApiImplicitParams(value = {
//            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
//            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer"),
//            @ApiImplicitParam(name = "nameOrCode", value = "名称或编码", paramType = "query", dataType = "String"),
//            @ApiImplicitParam(name = "startDate", value = "创建时间-开始", paramType = "query", dataType = "String"),
//            @ApiImplicitParam(name = "endDate", value = "创建时间-结束", paramType = "query", dataType = "String")
//    })
//    @PostMapping("/getPageList")
//    @RequiresPermissions("/audit/getPageList")
//    @ApiOperation(value = "获取禁用审核分页列表", notes = "获取禁用审核分页列表")
//    public Map<String, Object> getAuditPageList(GenericPageParam genericPageParam) {
//        LambdaQueryWrapper<Audit> queryWrapper = new LambdaQueryWrapper<>();
//        // 对名称或编码模糊查询
//        if (StringUtils.isNotBlank(genericPageParam.getNameOrCode())) {
//            queryWrapper.like(Audit::getContent, genericPageParam.getNameOrCode());
//        }
//        // 根据创建时间区间检索
//        if (genericPageParam.getStartDate() != null && genericPageParam.getEndDate() != null) {
//            queryWrapper.ge(Audit::getCreateTime, genericPageParam.getStartDate().atTime(0, 0, 0))
//                    .le(Audit::getCreateTime, genericPageParam.getEndDate().atTime(23, 59, 59));
//        }
//        // 设置排序规则
//        queryWrapper.orderByDesc(Audit::getCreateTime);
//        // 设置查询内容
//        queryWrapper.select(
//                Audit::getId,
//                Audit::getContent,
//                Audit::getCreateTime);
//        Page<Audit> page = this.auditService.page(getPage(), queryWrapper);
//        return getResult(page);
//    }

    @ApiOperation(value = "获取禁用审核详情", notes = "获取禁用审核详情")
    @GetMapping("/getById")
    @RequiresPermissions("/audit/getById")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "id", value = "id", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "type", value = "视频内容：VIDEO_CONTENT,展板内容：EXHIBITION_BOARD,学习内容：LEARNING_CONTENT", paramType = "query", dataType = "String", allowableValues = "VIDEO_CONTENT,EXHIBITION_BOARD,LEARNING_CONTENT,ACCOUNT", required = true)
    })
    @MethodLog(operModule = OperModule.CHECKVIDEO,operType = OperType.DETAILS)
    public Map<String, Object> getById(String id, String type) {
        HashMap<String, Object> resultMap = new HashMap<>();
        try {
            Audit audit = null;
            //只获取最新的一条审核数据
            audit = auditService.selectOne(id, type);
            resultMap.put("resultCode", "200");
            resultMap.put("message", "操作成功");
            resultMap.put("data", audit);
            return resultMap;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return getFailResult();
    }

    @GetMapping("/getPageAllList")
    @ApiOperation(value = "审核管理=========分页查询", notes = "审核管理=========分页查询")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "_index", value = "分页起始偏移量", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "_size", value = "返回条数", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "name", value = "账号名称或提交人", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "status", value = "待初审：TBC, 驳回：REFUSED,待复审：TBCA, 通过：APPROVED_FINAL", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "type", value = "视频内容：VIDEO_CONTENT,展板内容：EXHIBITION_BOARD,学习内容：LEARNING_CONTENT", paramType = "query", dataType = "String", allowableValues = "VIDEO_CONTENT,EXHIBITION_BOARD,LEARNING_CONTENT,ACCOUNT", required = true)
    })
    @MethodLog(operModule = OperModule.CHECKVIDEO,operType = OperType.SELECT)
    public Map<String, Object> getPageAllList(String name, String status, @NotBlank(message = "type参数不能为空") String type) {
        AuditStatusEnum auditStatus = null;
        AuditStatusEnum auditStatusLevel = null;
        AuditTypeEnum auditTypeEnum = AuditTypeEnum.valueOf(type);
//数据权限，暂时注释
//        TUser user = getcurUser();
//        switch (auditTypeEnum){
//            case ASSET:
//                if (user.getRoleList().contains("9")){
//                    auditStatusLevel=AuditStatusEnum.TBC;
//                }else if(user.getRoleList().contains("10")) {
//                    auditStatusLevel=AuditStatusEnum.TBCA;
//                }else {
//                    auditStatusLevel=AuditStatusEnum.APPROVED_FINAL;
//                }
//                break;
//            case EXHIBITION_BOARD:
//                if (user.getRoleList().contains("11")){
//                    auditStatusLevel=AuditStatusEnum.TBC;
//                }else if(user.getRoleList().contains("12")) {
//                    auditStatusLevel=AuditStatusEnum.TBCA;
//                }else {
//                    auditStatusLevel=AuditStatusEnum.APPROVED_FINAL;
//                }
//                break;
//            case LEARNING_CONTENT:
//                if (user.getRoleList().contains("13")){
//                    auditStatusLevel=AuditStatusEnum.TBC;
//                }else if(user.getRoleList().contains("14")) {
//                    auditStatusLevel=AuditStatusEnum.TBCA;
//                }else {
//                    auditStatusLevel=AuditStatusEnum.APPROVED_FINAL;
//                }
//                break;
//
//        }
        if (auditTypeEnum == null) {
            return getFailResult("type参数不正确");
        }
        if (StringUtils.isNotBlank(status)) {
            auditStatus = AuditStatusEnum.valueOf(status);
        }
        //
        try {
            Page<Audit> auditList = auditService.pageList(name, auditStatus, auditStatusLevel, auditTypeEnum, getPage());
            return getResult(auditList);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return getFailResult();
    }

    @PutMapping("/updateAuditAllById")
    @RequiresPermissions("/audit/update")
    @ApiOperation(value = "审核管理===根据id修改审核信息", notes = "审核管理===根据id修改审核信息")
    @MethodLog(operModule = OperModule.CHECKVIDEO,operType = OperType.AUDIT)
    public Map<String, Object> updateAuditAllById(@RequestBody @Validated AuditStatusParam auditStatusParam) {

        String id = auditStatusParam.getId();
        Audit audit = auditService.getById(id);
        if (audit == null) {
            return getFailResult("id参数有误");
        }
        //设置修改的审核状态
        audit.setStatus(auditStatusParam.getStatus());
        //为啥数据库有null值
        if (StringUtils.isBlank(audit.getLevel())) {
            audit.setLevel(AuditStatusEnum.TBC.name());
        }
        //初审
        if (AuditStatusEnum.TBC.name().equals(audit.getLevel())) {
            audit.setFirstRemarks(auditStatusParam.getRemarks());
        }
        //复审
        if (AuditStatusEnum.TBCA.name().equals(audit.getLevel())) {
            audit.setSecondRemarks(auditStatusParam.getRemarks());
        }

        boolean update = auditService.updateAuditAllById(audit);

        return update ? getSuccessResult() : getFailResult();
    }


}

