package cn.wisenergy.chnmuseum.party.auth.resolver;

import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthorizedException;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MyExceptionResolver implements HandlerExceptionResolver {

    @Override
    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        System.out.println("==============异常开始=============");
        System.out.println(ex.getMessage());

        // 如果是shiro无权操作，因为shiro 在操作auno等一部分不进行转发至无权限url
        if (ex instanceof UnauthorizedException) {
            System.out.println("==============超时未登录=============");
            return new ModelAndView("login");
        }

        if (ex instanceof AuthorizationException) {
            System.out.println("==============无权限=============");
        }
        System.out.println("==============异常结束=============");
        return null;
    }

}
