package cn.wisenergy.chnmuseum.party.common.log;

public enum OperModule {
    USER(1,"用户管理"),
    ROLE(2,"角色管理"),
    DEPT(3,"部门管理"),
    ORG(4,"机构管理"),
    DISPLAYCOPYRIGHT(5,"展板版权方管理"),
    DISPLAYCLASSIFY(6,"展板分类管理"),
    DISPLAYCONTENT(7,"展板内容管理"),
    VIDEOCOPYRIGHT(8,"视频版权方管理"),
    VIDEOCLASSIFY(9,"视频分类管理"),
    VIDEOCONTENT(10,"视频内容管理"),
    VIDEOREMIT(11,"视频汇出"),
    LEARNPROJECT(12,"学习项目管理"),
    LEARNCONTENT(13,"学习内容制作"),
    CHECKVIDEO(14,"视频审核"),
    CHECKDISPLAY(15,"展板审核"),
    CHECKLEARN(16,"平台学习内容审核"),
    RECHECK(17,"账号禁用审核"),
    INTERACTIVE(18,"互动内容"),
    STBBASE(19,"机顶盒基础信息管理"),
    STBOPERATION(20,"机顶盒运维信息管理"),
    STBACCOUNT(21,"机顶盒运维账号管理"),
    APPVERSION(22,"app版本管理"),
    PAGECUSTOM(23,"app界面自定义"),
    OVERVIEW(24,"统计概览"),
    INTERACTION(25,"互动统计"),
    TEND(26,"趋势分析"),
    LOG(27,"日志管理"),
    CHANGEPWD(28,"修改密码"),
    UNITADMIN(29,"账号管理"),
    STATISTICALUSER(30,"统计用户管理"),
    LOGIN(31,"登录管理")
    ;

    // 错误编码
    private Integer code;
    // 信息
    private String msg;

    // 相应编码有参构造函数
    OperModule(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
