package cn.wisenergy.chnmuseum.party.common.mybatis;

import cn.wisenergy.chnmuseum.party.auth.util.JwtTokenUtil;
import cn.wisenergy.chnmuseum.party.model.TUser;
import cn.wisenergy.chnmuseum.party.service.TUserService;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDateTime;

/**
 * 配置公共字段自动填充功能  @TableField(..fill = FieldFill.INSERT)
 * 特别注意，3.0-gamma之前的版本 MetaObjectHandler 是抽象类
 * 3.0-RC之后的版本MetaObjectHandler 是接口
 */
@Component
public class MetaObjectHandlerConfig implements MetaObjectHandler {

    @Resource
    private TUserService userService;

    @Override
    public void insertFill(MetaObject metaObject) {
        LocalDateTime now = LocalDateTime.now();
        Object createTime = getFieldValByName("createTime", metaObject);
        Object updateTime = getFieldValByName("updateTime", metaObject);
        if (createTime == null) {
            this.setFieldValByName("createTime", now, metaObject);
        }
        if (updateTime == null) {
            this.setFieldValByName("updateTime", now, metaObject);
        }
        final TUser currentUser = getCurrentUser();
        if (currentUser != null) {
            final String userName = JwtTokenUtil.getUsername(currentUser.getJwtToken());
            final TUser user = this.userService.selectByUsername(userName);
            this.setFieldValByName("userId", user.getId(), metaObject);
            this.setFieldValByName("userName", user.getUserName(), metaObject);
            this.setFieldValByName("orgName", user.getOrgName(), metaObject);
        }
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        LocalDateTime now = LocalDateTime.now();
        Object updateTime = getFieldValByName("updateTime", metaObject);
        if (updateTime == null) {
            this.setFieldValByName("updateTime", now, metaObject);
        }
    }

    /*
     * 获取当前登录用户
     *
     * @return 用户对象
     */
    private TUser getCurrentUser() {
        Subject subject = SecurityUtils.getSubject();
        if (subject != null) {
            return (TUser) subject.getPrincipal();
        }
        return null;
    }

}
