package cn.wisenergy.chnmuseum.party.common.validator;

import cn.wisenergy.chnmuseum.party.common.validator.constraints.EnumValue;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * 自定义枚举校验器
 *
 * @author mxy
 * @date 2020/4/23
 */
@Slf4j
public class EnumValueValidator implements ConstraintValidator<EnumValue, String> {

    // 枚举校验注解
    private EnumValue annotation;

    @Override
    public void initialize(EnumValue constraintAnnotation) {
        annotation = constraintAnnotation;
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        boolean result = false;

        Class<?> cls = annotation.target();
        boolean ignoreEmpty = annotation.ignoreEmpty();

        // target为枚举，并且value有值，或者不忽视空值，才进行校验
        if (cls.isEnum() && (StringUtils.isNotEmpty(value) || !ignoreEmpty)) {
            Object[] objects = cls.getEnumConstants();
            try {
                Method method = cls.getMethod("name");
                for (Object obj : objects) {
                    // 将传入值与枚举值比较
                    if (method.invoke(obj).toString().equals(value)) {
                        result = true;
                        break;
                    }
                }
            } catch (NoSuchMethodException | IllegalAccessException | InvocationTargetException e) {
                log.warn("EnumValidator call isValid() method exception.");
            }
        } else {
            result = true;
        }
        return result;
    }
}
