package cn.wisenergy.chnmuseum.party.common.video;

import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.Java2DFrameConverter;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

/**
 * 截取视频图片
 */
public class FrameGrabberKit {

    /**
     * 获取指定视频的帧并保存为图片至指定目录
     */
    public static InputStream fetchFrame(String videoUrl) throws Exception {
        FFmpegFrameGrabber ff = new FFmpegFrameGrabber(videoUrl);
        ff.start();
        int lenght = ff.getLengthInFrames();
        int i = 0;
        int interceptionFrames = 30;//截取第几帧
        //默认截取第50帧，如果第50帧大于视频总帧数的8成直接取长度lenght * 0.3
        if (interceptionFrames >= lenght * 0.8) {
            interceptionFrames = (int) (lenght * 0.3);
        }
        Frame f = null;
        while (i < lenght) {
            // 过滤 前  interceptionFrames 帧，避免出现全黑的图片，依自己情况而定
            f = ff.grabFrame();
            if ((i > interceptionFrames) && (f.image != null)) {
                break;
            }
            i++;
        }

        int imageWidth = f.imageWidth;
        int imageHeight = f.imageHeight;
        // 对截取的帧进行等比例缩放
//        int width = 800;
//        int height = (int) (((double) width / owidth) * oheight);
        Java2DFrameConverter converter = new Java2DFrameConverter();
        BufferedImage fecthedImage = converter.getBufferedImage(f);
        BufferedImage bi = new BufferedImage(imageWidth, imageHeight, BufferedImage.TYPE_3BYTE_BGR);
        bi.getGraphics().drawImage(fecthedImage.getScaledInstance(imageWidth, imageHeight, Image.SCALE_SMOOTH), 0, 0, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write(bi, "png", baos);
        InputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
        //ff.flush();
        ff.stop();
        return inputStream;
    }

}
