package cn.wisenergy.chnmuseum.party.common.vo;

/**
 * <p>
 * AJAX 返回对象类
 * </p>
 * 
 * @author hubin
 * @Date 2016-03-15
 */
public class AjaxResult {

	/**
	 * 是否成功
	 */
	private boolean success;

	/**
	 * 失败或成功的提示信息
	 */
	private String message;

	/**
	 * 返回的数据
	 */
	private Object data;

	public AjaxResult(boolean success, String message) {
		this(success, message, null);
	}

	public AjaxResult(Object data) {
		this(true, null, data);
	}

	public AjaxResult(boolean success, String message, Object data) {
		this.success = success;
		this.message = message;
		this.data = data;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public Object getData() {
		return data;
	}

	public void setData(Object data) {
		this.data = data;
	}

	public boolean isSuccess() {
		return success;
	}

	public void setSuccess(boolean success) {
		this.success = success;
	}

}
