package cn.wisenergy.chnmuseum.party.common.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 审核修改参数封装对象
 *
 * @author jiawei
 */
@Data
@ApiModel
public class AuditStatusParam implements Serializable {

    @ApiModelProperty("审核ID")
    @NotNull(message = "审核ID不能为空")
    private String id;

    @ApiModelProperty(value = "审核状态,驳回：REFUSED,通过：APPROVED_FINAL", allowableValues = "REFUSED,APPROVED_FINAL")
    @NotBlank(message = "审核状态不能为空")
    private String status;

    @ApiModelProperty("审核状态为驳回时，填写的审核意见")
    private String remarks;

}
