package cn.wisenergy.chnmuseum.party.conf;

import cn.wisenergy.chnmuseum.party.common.mvc.*;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

@Configuration
public class WebMvcConfig {

	@Resource
	private RequestMappingHandlerAdapter handlerAdapter;

	/**
	 * 增加字符串转日期的功能
	 */
	@PostConstruct
	public void initEditableValidation() {
		ConfigurableWebBindingInitializer initializer = (ConfigurableWebBindingInitializer) handlerAdapter
				.getWebBindingInitializer();
		if (initializer.getConversionService() != null) {
			GenericConversionService genericConversionService = (GenericConversionService) initializer
					.getConversionService();
			genericConversionService.addConverter(new StringToIntegerConverter());
			genericConversionService.addConverter(new StringToDateConverter());

			genericConversionService.addConverter(new StringToLocalDateConverter());
			genericConversionService.addConverter(new StringToLocalDateTimeConverter());
			genericConversionService.addConverter(new StringToLocalTimeConverter());
		}
	}

}