package cn.wisenergy.chnmuseum.party.core.aop;

import cn.wisenergy.chnmuseum.party.common.util.RedisUtil;
import cn.wisenergy.chnmuseum.party.core.annotations.RedisLock;
import lombok.extern.java.Log;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

/**
 * Created by xulinglin on 2019/1/24
 */
@Aspect
@Order(-1)//保证该AOP在@Transactional之前执行
@Component
@Log
public class RedisLockInterceptor {

    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    @Resource
    private RedisUtil redisUtil;
    @Pointcut("@annotation(redisLock)")
    public void pointCut(RedisLock redisLock) {}

    /**
     * 环绕通知
     * @param proceedingJoinPoint
     * @param redisLock
     * @return
     * @throws Throwable
     */
    @Around("pointCut(redisLock)")
    public Object around(ProceedingJoinPoint proceedingJoinPoint, RedisLock redisLock) throws Throwable {
        //方法执行前时间
        long currentTimeMillis= System.currentTimeMillis();
        //获取当前值
        String lockKey = redisLock.value();
        //获取上锁超时时间
        long time = redisLock.timeOut();
        //获取循环等待多少时间
        long timeLock = redisLock.timeLock();
        //控制当前循环
        boolean required = redisLock.required();
        required = timeLock > 0;
        //获取事务是否开启
        boolean transaction = redisLock.transaction();
        //获取随机id
        String name = String.valueOf(UUID.randomUUID());

        boolean flag = false;
        try {
            do {
                //set到redis
                flag = redisUtil.lock(lockKey,currentTimeMillis+"");
                //执行添加了注解的方法并返回
                if(flag){
                    Object result = proceedingJoinPoint.proceed();
                    return result;
                }
            }while (required);
        }catch (Exception e){
            e.printStackTrace();
        }catch (Throwable throwable) {
            throwable.printStackTrace();
        }finally {
            //最后在finally中删除
            if(flag){
                redisUtil.del(lockKey);
            }
        }
        return null;
    }

}
