package cn.wisenergy.chnmuseum.party.model;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 文件资产
 * </p>
 *
 * @author Danny Lee
 * @since 2021-04-01
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("asset")
@ApiModel(value = "文件资产", description = "文件资产")
public class Asset implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("文件资产ID/参考资料ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty("所属项(展板/视频内容)ID")
    @TableField("ref_item_id")
    private String refItemId;

    @ApiModelProperty("文件名")
    @TableField("file_name")
    private String fileName;

    @ApiModelProperty("扩展名")
    @TableField("file_ext_name")
    private String fileExtName;

    @ApiModelProperty("多媒体类型")
    @TableField("file_type")
    private String fileType;

    @ApiModelProperty("文件大小(B)")
    @TableField("file_size")
    private Long fileSize;

    @ApiModelProperty("文件分类")
    @TableField("file_cat")
    private String fileCat;

    @ApiModelProperty("下载链接")
    @TableField("file_url")
    private String fileUrl;

    @ApiModelProperty("视频缩略图")
    @TableField("thumbnail")
    private String thumbnail;

    @ApiModelProperty("语言")
    @TableField("language")
    private String language;

    @ApiModelProperty("MD5")
    @TableField("md5")
    private String md5;

    @ApiModelProperty("是否已删除")
    @TableField("is_deleted")
    private Boolean deleted;

    @ApiModelProperty("创建日期")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    @ApiModelProperty("修改日期")
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updateTime;

    @ApiModelProperty("展板ID")
    @TableField(exist = false)
    private String exhibitionBoardId;

    @ApiModelProperty("展板名称")
    @TableField(exist = false)
    private String exhibitionBoardName;

    @ApiModelProperty("展板图片")
    @TableField(exist = false)
    private String exhibitionBoardCover;

    @ApiModelProperty("视频类别")
    @TableField(exist = false)
    private String videoContentCatName;

    @ApiModelProperty("视频版权方")
    @TableField(exist = false)
    private String videoContentCopyrightOwnerName;

}
