package cn.wisenergy.chnmuseum.party.model;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 展板互动
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("board_talking")
@ApiModel(value = "BoardTalking对象", description = "展板互动")
public class BoardTalking implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "展板互动信息ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "展板ID")
    @TableField("board_id")
    private String boardId;

    @ApiModelProperty(value = "真实姓名")
    @TableField("real_name")
    private String realName;

    @ApiModelProperty(value = "评论")
    @TableField("comment")
    private String comment;

    @ApiModelProperty(value = "附件URL")
    @TableField("asset")
    private String asset;

    @ApiModelProperty(value = "创建日期")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private LocalDateTime createTime;

}
