package cn.wisenergy.chnmuseum.party.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author Yang Jianlong
 * @since 2018-12-27
 */
@TableName("page_view_record")
public class PageViewRecord extends Model<PageViewRecord> {

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.UUID)
    private String id;
    /**
     * 用户ID
     */
    @TableField("user_id")
    private String userId;
    /**
     * 网点ID
     */
    @TableField("bank_id")
    private String bankId;
    /**
     * 浏览时间
     */
    @TableField("create_time")
    private Date createTime;
    /**
     * 详情信息ID(具体的业务，网点，活动，产品ID)
     */
    @TableField("detail_id")
    private String detailId;
    /**
     * 页面类型:1-业务办理助手2-网点服务地图3-热门产品4-热门活动
     */
    private Integer type;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getBankId() {
        return bankId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getDetailId() {
        return detailId;
    }

    public void setDetailId(String detailId) {
        this.detailId = detailId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "PageViewRecord{" +
        ", id=" + id +
        ", userId=" + userId +
        ", bankId=" + bankId +
        ", createTime=" + createTime +
        ", detailId=" + detailId +
        ", type=" + type +
        "}";
    }
}
