package cn.wisenergy.chnmuseum.party.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("run_log")
@ApiModel(value = "RunLog对象", description = "")
public class RunLog implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "运行日志ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "机顶盒MAC地址")
    @TableField("mac_addr")
    private String macAddr;

    @ApiModelProperty(value = "所属单位ID")
    @TableField("organ_id")
    private String organId;

    @ApiModelProperty(value = "学习内容ID")
    @TableField("learning_content_id")
    private String learningContentId;

    @ApiModelProperty(value = "开始时间")
    @TableField("start_time")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "结束时间")
    @TableField("end_time")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "机构名称")
    @TableField(exist = false)
    private String orgName;

    @ApiModelProperty(value = "学习内容名称")
    @TableField(exist = false)
    private String learnName;

    @ApiModelProperty("开始时间")
    @TableField(exist = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    private Date startDate;

    @ApiModelProperty("结束时间")
    @TableField(exist = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    private Date endDate;
}
