package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.injector.methods.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * <p>
 * 看板播放排行
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-20
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("statistic")
@ApiModel(value = "播放数据统计", description = "播放数据统计")
public class Statistic implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "IDID不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("总机构数")
    @TableField("organ_number")
        @NotNull(message = "总机构数不能为空", groups = {Add.class, Update.class})
        private Integer organNumber;
    
    @ApiModelProperty("看板名称")
    @TableField("board_number")
        @NotNull(message = "看板名称不能为空", groups = {Add.class, Update.class})
        private Integer boardNumber;
    
    @ApiModelProperty("播放次数")
    @TableField("play_number")
    private Integer playNumber;
    
    @ApiModelProperty("互动数量")
    @TableField("interaction_number")
    private Integer interactionNumber;
    
    @ApiModelProperty("数据时间")
    @TableField("data_time")
    private LocalDate dataTime;
    



}
