package cn.wisenergy.chnmuseum.party.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;

/**
 * <p>
 * 展板统计信息表
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-25
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("t_board_statistic")
@ApiModel(value = "展板统计信息表", description = "展板统计信息表")
public class TBoardStatistic implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键id")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "主键id不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("展板id")
    @TableField("board_id")
        @NotBlank(message = "展板id不能为空", groups = {Add.class, Update.class})
        private String boardId;

    @ApiModelProperty("展板名称")
    @TableField("board_name")
    private String boardName;

    @ApiModelProperty("播放机构id")
    @TableField("organ_id")
        private String organId;

    @ApiModelProperty("机构所在地区id")
    @TableField("area_id")
    private Integer areaId;

    @ApiModelProperty("播放次数")
    @TableField("play_number")
    private Integer playNumber;

    @ApiModelProperty("播放日期yyyy-MM-dd")
    @TableField("play_date")
    private String playDate;

    @ApiModelProperty("用户id")
    @TableField(exist = false)
    private String userId;

}
