package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 展板统计概览
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-26
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "展板统计概览", description = "展板统计概览")
public class TBoardSurvey implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("统计时间 年：yyyy 或 月： yyyyMM")
    private String statisticDate;

    @ApiModelProperty("地区")
    private String areaId;

    @ApiModelProperty("机构id")
    private String organId;

    @ApiModelProperty("展板总播放量")
    private Integer playCnt;

    @ApiModelProperty("组织单位量")
    private Integer orgCnt;

    @ApiModelProperty("展板数量")
    private Integer boardCnt;

    @ApiModelProperty("互动总量")
    private Integer interactionCnt;


}
