package cn.wisenergy.chnmuseum.party.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.TableField;

/**
 * <p>
 * 地区看板播放统计
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-26
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("t_district_board_statistic")
@ApiModel(value = "地区看板播放统计", description = "地区看板播放统计")
public class TDistrictBoardStatistic implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("播放次数")
    @TableField("play_date")
    private String playDate;


    @ApiModelProperty("播放次数")
    @TableField("play_number")
    private Integer playNumber;


    @ApiModelProperty("地区名称")
    @TableField(exist = false)
    private String areaName;

    @ApiModelProperty("看板数量")
    @TableField(exist = false)
    private Integer boardCnt;


}
