package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 视频
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-16
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("video_content")
@ApiModel(value = "视频内容", description = "视频内容")
public class VideoContent implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("视频内容ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "视频内容ID不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("视频内容名称")
    @TableField("name")
    @NotBlank(message = "视频内容名称不能为空", groups = {Add.class, Update.class})
    private String name;

    @ApiModelProperty("视频内容版权方ID")
    @TableField("video_content_copyright_owner_id")
    private String videoContentCopyrightOwnerId;

    @ApiModelProperty("视频内容分类ID")
    @TableField("video_content_cat_id")
    private String videoContentCatId;

    @ApiModelProperty("视频内容缩略图")
    @TableField("thumbnail")
    @NotBlank(message = "视频内容缩略图不能为空", groups = {Add.class})
    private String thumbnail;

    @ApiModelProperty("审核状态")
    @TableField("audit_status")
    private String auditStatus;

    @ApiModelProperty("是否上架")
    @TableField("is_published")
    private Boolean published;

    @ApiModelProperty("是否已删除")
    @TableField("is_deleted")
    private Boolean deleted;

    @ApiModelProperty("创建日期")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    @ApiModelProperty("修改日期")
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updateTime;

    @ApiModelProperty("视频内容分类名称")
    @TableField(exist = false)
    private String videoContentCatName;

    @ApiModelProperty("视频内容版权方名称")
    @TableField(exist = false)
    private String videoContentCopyrightOwnerName;

    @ApiModelProperty("视频文件ID列表(添加/更新使用)")
    @TableField(exist = false)
    private List<String> videoFileIdList;

    @ApiModelProperty("视频文件信息列表")
    @TableField(exist = false)
    private List<Asset> videoFileList;

    @ApiModelProperty("审核意见记录")
    @TableField(exist = false)
    private List<Audit> auditHistoryList;

}
