package cn.wisenergy.chnmuseum.party.model;

import cn.wisenergy.chnmuseum.party.common.validator.groups.Add;
import cn.wisenergy.chnmuseum.party.common.validator.groups.Update;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 视频内容分类
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-17
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("video_content_cat")
@ApiModel(value = "视频内容分类", description = "视频内容分类")
public class VideoContentCat implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("视频内容分类ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @NotNull(message = "视频内容分类不能为空", groups = {Update.class})
    private String id;

    @ApiModelProperty("视频内容分类名称")
    @TableField("name")
    @NotBlank(message = "视频内容分类名称不能为空", groups = {Add.class, Update.class})
    private String name;

    @ApiModelProperty("备注")
    @TableField("remarks")
    private String remarks;

    @ApiModelProperty("版权方ID")
    @TableField("copyright_owner_id")
    private String copyrightOwnerId;

    @ApiModelProperty("创建日期")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    @ApiModelProperty("更新日期")
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updateTime;

    @ApiModelProperty("版权方名称")
    @TableField(exist = false)
    private String copyrightOwnerName;

}
