package cn.wisenergy.chnmuseum.party.service;

import cn.wisenergy.chnmuseum.party.common.util.DateUtil80;
import cn.wisenergy.chnmuseum.party.model.PageViewRecord;
import cn.wisenergy.chnmuseum.party.model.PageViews;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

@Service
public class PublicService {

    @Resource
    private RedisTemplate redisTemplate;

    @Resource
    private IPageViewRecordService pageViewRecordService;

    @Resource
    private IPageViewsService pageViewsService;

    /**
     * 缓存页面访问量数据，超过5分钟或者数据量超过10条时直接插入数据库
     *
     * @param detailId 详情信息ID(具体的业务，网点，活动，产品ID)
     * @param userId   用户ID
     * @param bankId   网点ID
     * @param type     页面类型:1-业务办理助手2-网点服务地图3-热门产品4-热门活动
     */
    public void cacheData(String detailId, String userId, String bankId, Integer type) {
        String recordsKey = "pageViewRecords";
        String timeKey = "pageViewRecordsTime";

        Date currDateTime = DateUtil80.getCurrDateTime();
        Date currDate = DateUtil80.getCurrDate();

        PageViewRecord pageViewRecord = new PageViewRecord();
        pageViewRecord.setUserId(userId);
        pageViewRecord.setBankId(bankId);
        pageViewRecord.setCreateTime(currDateTime);//年月日时分秒
        pageViewRecord.setType(type);
        pageViewRecord.setDetailId(detailId);
        redisTemplate.opsForSet().add(recordsKey, pageViewRecord);
        if (!redisTemplate.hasKey(timeKey)) {
            //没有时间戳标记说明是第一次进入
            redisTemplate.opsForValue().set(timeKey, currDateTime);
        } else {
            //取出记录集合
            Set<PageViewRecord> recordValues = redisTemplate.opsForSet().members(recordsKey);

            int size = recordValues.size();
            //取出时间判断和当前时间有没有超过5分钟
            Date timeValue = (Date) redisTemplate.opsForValue().get(timeKey);
            long disSecond = (currDateTime.getTime() - timeValue.getTime()) / 1000;

            //缓存的数据量达到10条以上或者时间超过5分钟，进行数据存储
            if (size >= 10 || disSecond >= 300) {
                int typeOne = 0;
                int typeTwo = 0;
                int typeThree = 0;
                int typeFour = 0;
                //数据量达到10条以上，将数据插入数据库，并且清空redis
                Iterator<PageViewRecord> iterator = recordValues.iterator();
                while (iterator.hasNext()) {
                    //单条缓存的数据
                    PageViewRecord cacheValue = iterator.next();
                    pageViewRecord = new PageViewRecord();

                    pageViewRecord.setUserId(cacheValue.getUserId());
                    pageViewRecord.setBankId(cacheValue.getBankId());
                    pageViewRecord.setCreateTime(cacheValue.getCreateTime());
                    pageViewRecord.setType(cacheValue.getType());
                    pageViewRecord.setDetailId(cacheValue.getDetailId());
                    //将数据插入数据库
                    this.pageViewRecordService.save(pageViewRecord);
                    //记录每个页面的访问数量
                    if (cacheValue.getType() == 1) {
                        typeOne += 1;
                    } else if (cacheValue.getType() == 2) {
                        typeTwo += 1;
                    } else if (cacheValue.getType() == 3) {
                        typeThree += 1;
                    } else if (cacheValue.getType() == 4) {
                        typeFour += 1;
                    }
                }

                QueryWrapper<PageViews> viewsWrapper = new QueryWrapper<>();
                PageViews pageViews = new PageViews();
                if (typeOne != 0) {
                    viewsWrapper.eq("type", 1);
                    PageViews one = this.pageViewsService.getOne(viewsWrapper);
                    if (one != null) {
                        pageViews.setId(one.getId());
                        pageViews.setTimes(one.getTimes() + typeOne);
                        this.pageViewsService.updateById(pageViews);
                    } else {
                        pageViews.setType(1);
                        pageViews.setPageName("业务办理助手");
                        pageViews.setTimes(typeOne);
                        pageViews.setViewDate(currDate);
                        this.pageViewsService.save(pageViews);
                    }
                }
                if (typeTwo != 0) {
                    viewsWrapper = new QueryWrapper<>();
                    pageViews = new PageViews();
                    viewsWrapper.eq("view_date", currDate);
                    viewsWrapper.eq("type", 2);
                    PageViews one = this.pageViewsService.getOne(viewsWrapper);
                    if (one != null) {
                        pageViews.setId(one.getId());
                        pageViews.setTimes(one.getTimes() + typeTwo);
                        this.pageViewsService.updateById(pageViews);
                    } else {
                        pageViews.setType(2);
                        pageViews.setPageName("网点服务地图");
                        pageViews.setTimes(typeTwo);
                        pageViews.setViewDate(currDate);
                        this.pageViewsService.save(pageViews);
                    }
                }
                if (typeThree != 0) {
                    viewsWrapper = new QueryWrapper<>();
                    pageViews = new PageViews();
                    viewsWrapper.eq("view_date", currDate);
                    viewsWrapper.eq("type", 3);
                    PageViews one = this.pageViewsService.getOne(viewsWrapper);
                    if (one != null) {
                        pageViews.setId(one.getId());
                        pageViews.setTimes(one.getTimes() + typeThree);
                        this.pageViewsService.updateById(pageViews);
                    } else {
                        pageViews.setType(3);
                        pageViews.setPageName("热门产品");
                        pageViews.setTimes(typeThree);
                        pageViews.setViewDate(currDate);
                        this.pageViewsService.save(pageViews);
                    }
                }
                if (typeFour != 0) {
                    viewsWrapper = new QueryWrapper<>();
                    pageViews = new PageViews();
                    viewsWrapper.eq("view_date", currDate);
                    viewsWrapper.eq("type", 4);
                    PageViews one = this.pageViewsService.getOne(viewsWrapper);
                    if (one != null) {
                        pageViews.setId(one.getId());
                        pageViews.setTimes(one.getTimes() + typeFour);
                        this.pageViewsService.updateById(pageViews);
                    } else {
                        pageViews.setType(4);
                        pageViews.setPageName("热门活动");
                        pageViews.setTimes(typeFour);
                        pageViews.setViewDate(currDate);
                        this.pageViewsService.save(pageViews);
                    }
                }
                //插入数据库后清空redis
                redisTemplate.opsForValue().set(timeKey, currDateTime);
                redisTemplate.delete(recordsKey);
            }
        }
    }
}
