package cn.wisenergy.chnmuseum.party.service;

import cn.wisenergy.chnmuseum.party.model.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 展板统计信息表 服务接口
 * </p>
 *
 * @author Danny Lee
 * @since 2021-03-25
 */
public interface TBoardStatisticService extends IService<TBoardStatistic> {

    Object boardStatisticInfo(TBoardStatistic tBoardStatistic, boolean autoUpdate);

    /**
     * 更新展板统计信息
     */
    void updateBoardStatisticInfo(List<TBoardStatistic> statisticList, String redisKey);

    /**
     * 获取展板播放排行
     * @param page
     * @param rank
     * @return
     */
    Page<TBoardPlayRank> getBoardRankPageList(Page<TBoardPlayRank> page,TBoardPlayRank rank);

    /**
     * 获取展板播放趋势
     * @param page
     * @param rank
     * @return
     */
    Page<TBoardPlayTrend> getBoardTrendPageList(Page<TBoardPlayTrend> page, TBoardPlayTrend rank);

    /**
     * 获取地区看板统计信息
     * @param page
     * @param district
     * @return
     */
    Page<TDistrictBoardStatistic> getBoardDistrictPageList(Page<TDistrictBoardStatistic> page, TDistrictBoardStatistic district);

    /**
     * 获取展板统计概览
     * @param survey
     * @return
     */
    TBoardSurvey getBoardSurvey(@Param("survey") TBoardSurvey survey);

    /**
     * 获取互动频次统计
     * @param page
     * @param frequencyDate
     * @return
     */
    Page getInteractionFrequency(Page page,String frequencyDate);

    List getBoardProvincePlayTotalList(String organId);

}
